using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] firstLine = Console.ReadLine().Split();
        int n = int.Parse(firstLine[0]);
        int W = int.Parse(firstLine[1]);
        float epsilon = float.Parse(firstLine[2]);

        int[] value = new int[n];
        int[] weight = new int[n];

        for (int i = 0; i < n; i++)
        {
            string[] line = Console.ReadLine().Split();
            weight[i] = int.Parse(line[0]);
            value[i] = int.Parse(line[1]);
        }

        int[,] dp = new int[n + 1, W + 1];

        for (int i = 1; i <= n; i++)
        {
            for (int w = 0; w <= W; w++)
            {
                if (weight[i - 1] <= w)
                    dp[i, w] = Math.Max(dp[i - 1, w], dp[i - 1, w - weight[i - 1]] + value[i - 1]);
                else
                    dp[i, w] = dp[i - 1, w];
            }
        }

        List<int> chosen = new List<int>();
        int remainingWeight = W;
        for (int i = n; i >= 1; i--)
        {
            if (dp[i, remainingWeight] != dp[i - 1, remainingWeight])
            {
                chosen.Add(i);
                remainingWeight -= weight[i - 1];
            }
        }

        chosen.Reverse();
        Console.WriteLine(chosen.Count);
        Console.WriteLine(string.Join(" ", chosen));
    }
}